/*
 * Decompiled with CFR 0.152.
 */
package com.resource;

import com.Application;
import com.dao.LoginDao;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.TncLog;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/Login"})
public class Login {
    private final LoginDao loginDao;
    private final Application application;
    private final TncLog log;

    public Login(LoginDao loginDao, Application application, TncLog log) {
        this.loginDao = loginDao;
        this.application = application;
        this.log = log;
    }

    @PostMapping(consumes={"application/json"})
    public synchronized ResponseEntity<?> login(@RequestBody String body) throws Exception {
        JSONObject obj = new JSONObject(body);
        obj = ConvertStr.rebuildJsonObject((JSONObject)obj);
        LoginDto.LoginDtoBuilder myLogin = LoginDto.builder();
        JSONArray arr = obj.getJSONArray("userinfo");
        JSONObject jo = arr.getJSONObject(0);
        if (jo.has("username")) {
            myLogin.userName(jo.getString("username"));
        }
        if (jo.has("userpass")) {
            myLogin.userPass(jo.getString("userpass"));
        }
        if (jo.has("dbname")) {
            myLogin.databaseName(jo.getString("dbname"));
        }
        if (jo.has("subsystemid")) {
            myLogin.subSystemId(jo.getInt("subsystemid"));
        }
        if (jo.has("serial")) {
            String serial = jo.getString("serial");
            myLogin.serial(serial);
            this.log.info("NEW LOGIN SERIAL: " + serial);
        }
        if (jo.has("isandroid")) {
            boolean isAndroid = jo.getBoolean("isandroid");
            myLogin.isAndroid(isAndroid);
        }
        if (jo.has("ver")) {
            myLogin.smartHelpVersion(jo.getString("ver"));
        }
        if (!jo.getString("username").equals("TNCPosLog")) {
            return this.loginDao.setLogin(myLogin.build());
        }
        return this.loginDao.logPosLogin(myLogin.build());
    }

    @PostMapping(consumes={"application/x-www-form-urlencoded"})
    public synchronized ResponseEntity<?> login(@RequestParam(value="dbname") String dbname, @RequestParam(value="username") String username, @RequestParam(value="userpass") String userpass) {
        LoginDto myLogin = LoginDto.builder().databaseName(dbname).userName(username).userPass(userpass).userCodeInc(0).build();
        return this.loginDao.setLogin(myLogin);
    }

    @GetMapping(value={"/UserInfo"})
    public ResponseEntity<?> getUserInfo(HttpServletRequest request) {
        if (!Application.isAccessWebService || !this.application.usePack1) {
            return null;
        }
        return this.loginDao.getUserInfo(request);
    }
}

